VERSION 5.00
Begin VB.Form frmSelectMonth 
   BorderStyle     =   1  'Fixed Single
   Caption         =   "View Month On Calendar"
   ClientHeight    =   2340
   ClientLeft      =   45
   ClientTop       =   330
   ClientWidth     =   4050
   Icon            =   "frmSelectMonth.frx":0000
   LinkTopic       =   "Form2"
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   2340
   ScaleWidth      =   4050
   StartUpPosition =   3  'Windows Default
   Begin VB.CommandButton cmdDisplay 
      Caption         =   "Display"
      Default         =   -1  'True
      Height          =   375
      Left            =   1440
      TabIndex        =   0
      TabStop         =   0   'False
      Top             =   1800
      Width           =   1215
   End
   Begin VB.CommandButton cmdCancel 
      Cancel          =   -1  'True
      Caption         =   "Cancel"
      Height          =   375
      Left            =   2640
      TabIndex        =   1
      TabStop         =   0   'False
      Top             =   1800
      Width           =   1215
   End
   Begin VB.Frame fraCalendarStyle 
      Caption         =   "Calendar Style"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   1335
      Left            =   1920
      TabIndex        =   4
      Top             =   240
      Width           =   1935
      Begin VB.OptionButton optGregorian 
         Caption         =   "Gregorian"
         Height          =   495
         Left            =   240
         TabIndex        =   8
         TabStop         =   0   'False
         Top             =   240
         Value           =   -1  'True
         Width           =   1215
      End
      Begin VB.OptionButton optJulian 
         Caption         =   "Julian"
         Height          =   495
         Left            =   240
         TabIndex        =   7
         TabStop         =   0   'False
         Top             =   720
         Width           =   1215
      End
   End
   Begin VB.TextBox txtYear 
      Height          =   285
      Left            =   240
      MaxLength       =   8
      TabIndex        =   3
      Top             =   1200
      Width           =   1335
   End
   Begin VB.ComboBox ComboMonths 
      Height          =   315
      ItemData        =   "frmSelectMonth.frx":030A
      Left            =   240
      List            =   "frmSelectMonth.frx":0335
      Style           =   2  'Dropdown List
      TabIndex        =   2
      Top             =   480
      Width           =   1335
   End
   Begin VB.Label Label1 
      BackStyle       =   0  'Transparent
      Caption         =   "Select Month:"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   255
      Left            =   240
      TabIndex        =   5
      Top             =   240
      Width           =   1215
   End
   Begin VB.Label Label2 
      BackStyle       =   0  'Transparent
      Caption         =   "Select Year:"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   375
      Left            =   240
      TabIndex        =   6
      Top             =   960
      Width           =   1215
   End
End
Attribute VB_Name = "frmSelectMonth"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False

Private Sub cmdCancel_Click()
   frmSelectMonth.Visible = False
End Sub

Private Sub cmdDisplay_Click()
   'Determine which calendar style is selected:
   If optGregorian.Value = True Then CalStyle = "Gregorian"
   If optJulian.Value = True Then CalStyle = "Julian"
   
   'Error Checking:
   On Error GoTo 6
   ErrorFlag = 0: ErrorCount = 0
   If ComboMonths = "" Then
      ErrorFlag = 1: ErrorCount = ErrorCount + 1
   End If
   If txtYear.Text = "" Then
      ErrorFlag = 2: ErrorCount = ErrorCount + 1
   ElseIf ((txtYear.Text < 0 And (CalStyle = "Julian")) Or txtYear.Text > 1000000) Then
      ErrorFlag = 3: ErrorCount = ErrorCount + 1
   ElseIf CalStyle = "Gregorian" Then
      If (txtYear < 1582) Then
         ErrorFlag = 4: ErrorCount = ErrorCount + 1
      ElseIf (txtYear = 1582) Then
         Select Case ComboMonths
            Case "October", "November", "December"
            Case Else
               ErrorFlag = 4: ErrorCount = ErrorCount + 1
         End Select
      End If
   End If
   
   TargetYear = txtYear + 0
   This_Will_Never_Be_2 = 3
   If This_Will_Never_Be_2 = 2 Then
6     TargetYear = 0
      ErrorFlag = 5: 'ErrorCount = ErrorCount + 1
      If txtYear = "" Then ErrorFlag = 2
      Resume Next
   End If
   
   If ErrorCount > 1 Then ErrorFlag = 6
   'Display Error Message:
   If ErrorFlag = 1 Then atemp = MsgBox("A month must be selected.", 48, "No Month Selected")
   If ErrorFlag = 2 Then atemp = MsgBox("A year must be entered.", 48, "No Year Entered")
   If ErrorFlag = 3 Then atemp = MsgBox("Please enter a value from 1 to 1000000.", 48, "Invalid Year Entry")
   If ErrorFlag = 4 Then atemp = MsgBox("For the Gregorian Calendar, please make sure the " & Chr(13) & "month selected is October 1582 or later.", 48, "Invalid Month Selection")
   If ErrorFlag = 5 Then atemp = MsgBox("The year must contain only numbers.", 48, "Invalid Year Entry")
   If ErrorFlag = 6 Then atemp = MsgBox("Please select a month and enter a valid year in the year field.", 48, "Error")
   If ErrorFlag <> 0 Then Exit Sub

   'Determine which calendar style is selected:
   If optGregorian.Value = True Then CalStyle = "Gregorian"
   If optJulian.Value = True Then CalStyle = "Julian"
   
   'Get necessary input:
   TargetYear = txtYear + 0
   Monthh = ComboMonths
   Its_A_Leap_Year = Form1.Is_It_A_Leap_Year(TargetYear, CalStyle)
   ReferenceYear = 2000
   
   'Attempt to make the code sound more like English.
   If Its_A_Leap_Year Then Its_Not_A_Leap_Year = 0 Else Its_Not_A_Leap_Year = 1
   
   'Determine the weekday of the reference month, which is the corresponding month in the reference year (2000):
   If CalStyle = "Gregorian" Then _
      ReferenceWeekDay = Form1.Define_Month(Monthh, "Get Base Date Weekday Greg 2000")
   If CalStyle = "Julian" Then _
      ReferenceWeekDay = Form1.Define_Month(Monthh, "Get Base Date Weekday Jul 2000")
   'Next Line: Determine the number of years that the year to be displayed is from the reference year.
   YearDif = ReferenceYear - TargetYear 'tested
   
   'Determine how many leap dates are between the reference month and the target month:
   NumLeapYears = 0
   Select Case Monthh
     Case "January", "February"
        NumLeapYears = (Int((YearDif) / 4)) 'tested
     Case Else
        NumLeapYears = (Int((YearDif - 1) / 4)) + 1 'tested
   End Select
   
   'Adjust for the fact that, in the Gregorian Calendar, all years divisible by 100 but not by 400 are not leap years:
   LeapException = 0
   If TargetYear < ReferenceYear Then One = -1 Else One = 1
   If CalStyle = "Gregorian" Then
      For i = (ReferenceYear + One) To TargetYear Step (One)
         Select Case Monthh
          Case "January", "February"
            If (TargetYear < 2000) And ((i Mod 100) = 0) And (i Mod 400 <> 0) Then _
              LeapException = LeapException - 1
            If (TargetYear > 2000) And ((i Mod 100) = 1) And ((i Mod 400) <> 1) Then _
              LeapException = LeapException + 1
          Case Else
            If (TargetYear < 2000) And ((i Mod 100) = 99) And (i Mod 400 <> 399) Then _
              LeapException = LeapException - 1
            If (TargetYear > 2000) And ((i Mod 100) = 0) And (i Mod 400 <> 0) Then _
              LeapException = LeapException + 1
         End Select
      Next
   End If
   
   AdjustedYearDif = (YearDif + NumLeapYears + LeapException)
   'Print AdjustedYearDif
   WeekDayDif = AdjustedYearDif Mod 7
   
   'Deteremine the what day of the week the 1st of the selected month falls on.
   TargetWeekDay = ReferenceWeekDay - WeekDayDif
   If TargetWeekDay < 1 Then TargetWeekDay = TargetWeekDay + 7
   If TargetWeekDay > 7 Then TargetWeekDay = TargetWeekDay - 7
   'Print TargetWeekDay 'Test Statement
   
   'Determine the number of days in the target month:
   If Its_A_Leap_Year Then LeapString = "Get Max Days Leap Year"
   If Its_Not_A_Leap_Year Then LeapString = "Get Max Days"
   MaxDays = Form1.Define_Month(Monthh, LeapString)
   'Print MaxDays 'Test Statement
   
   'Display the Calendar Headings:
   Form1.lblMonthYear = Monthh & " " & TargetYear
   Form1.lblCalendarNameOverCalendar.Caption = UCase$(CalStyle) & " CALENDAR"
   
   frmLargeCalendar.lblMonthYear = Monthh & " " & TargetYear
   frmLargeCalendar.lblCalendarNameOverCalendar.Caption = UCase$(CalStyle) & " CALENDAR"
   frmLargeCalendar.lblMonthNumber.Caption = Form1.Define_Month(Monthh, "Get Month Number")
   frmLargeCalendar.lblMonthNumberShadow.Caption = Form1.Define_Month(Monthh, "Get Month Number")
   frmLargeCalendar.lblShowDate.Caption = ""
   
   Form1.lblStoreMonth.Caption = Monthh 'Next 2 lines: Record name and year on calendar (in invisible labels), for use by other procedures.
   Form1.lblStoreYear.Caption = TargetYear
   Form1.Enable_Calendar_Month_Scrolling 'Ensure that user has the ability to scroll through the months displayed on the calendar when a valid month is there.
   
   'Display the month on the calendar:
   'Display the preceding month on the calendar:
   TargetMonthNumeric = Form1.Define_Month(Monthh, "Get Month Number") 'Get the numerical equivalent of the current month.
   PrevMaxDays = Form1.Define_Month(TargetMonthNumeric - 1, LeapString) 'Get the number of days for the preceding month.
   Ccount = PrevMaxDays + 1
   For i = (TargetWeekDay - 1) To 1 Step -1
      Ccount = Ccount - 1
      Form1.lblCalDate(i - 1).ForeColor = &H80000011 'Make the dates appear black.
      Form1.lblCalDate(i - 1).Caption = Ccount
      
      frmLargeCalendar.lblCalDate(i - 1).ForeColor = &H80000011 'Make the dates appear black.
      frmLargeCalendar.lblCalDate(i - 1).Caption = Ccount
   Next
   'Display current (target) month on the calendar:
   Ccount = 0
   For i = TargetWeekDay To ((TargetWeekDay + MaxDays) - 1)
      Ccount = Ccount + 1
      Form1.lblCalDate(i - 1).ForeColor = &H80000012 'Make the dates appear black.
      Form1.lblCalDate(i - 1).Caption = Ccount
      
      frmLargeCalendar.lblCalDate(i - 1).ForeColor = &H80000012 'Make the dates appear black.
      frmLargeCalendar.lblCalDate(i - 1).Caption = Ccount
   Next
   'Display the following month on the calendar:
   Ccount = 0
   For i = (TargetWeekDay + MaxDays) To 42
      Ccount = Ccount + 1
      Form1.lblCalDate(i - 1).ForeColor = &H80000011 'Make the dates appear grey.
      Form1.lblCalDate(i - 1).Caption = Ccount
      
      frmLargeCalendar.lblCalDate(i - 1).ForeColor = &H80000011 'Make the dates appear grey.
      frmLargeCalendar.lblCalDate(i - 1).Caption = Ccount
   Next
   If CalStyle = "Julian" Then frmLargeCalendar.cboShowTaskListFor.Enabled = False
   If CalStyle = "Gregorian" Then frmLargeCalendar.cboShowTaskListFor.Enabled = True
   frmSelectMonth.Visible = False
   frmLargeCalendar.Display_TaskList (CalStyle)
   Form1.Display_Side_Calendars Form1.lblStoreMonth.Caption, Form1.lblStoreYear.Caption, CalStyle
   Form1.Display_Holidays_On_Calendar (CalStyle)
End Sub
Private Sub Form_Deactivate()
   frmSelectMonth.Visible = False
End Sub
Private Sub optGregorian_Click()
   optJulian.Value = False
End Sub
Private Sub optJulian_Click()
   optGregorian.Value = False
End Sub
